/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.internal;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.jvm.toolchain.JavaLanguageVersion;
import org.gradle.jvm.toolchain.JvmImplementation;
import org.gradle.jvm.toolchain.JvmVendorSpec;
import org.gradle.jvm.toolchain.internal.DefaultJvmVendorSpec;
import org.gradle.jvm.toolchain.internal.JavaToolchainSpecInternal;

public class DefaultToolchainSpec
implements JavaToolchainSpecInternal {
    private final Property<JavaLanguageVersion> languageVersion;
    private final Property<JvmVendorSpec> vendor;
    private final Property<JvmImplementation> implementation;

    @Inject
    public DefaultToolchainSpec(ObjectFactory factory) {
        this.languageVersion = factory.property(JavaLanguageVersion.class);
        this.vendor = factory.property(JvmVendorSpec.class).convention((Object)DefaultToolchainSpec.getConventionVendor());
        this.implementation = factory.property(JvmImplementation.class).convention((Object)DefaultToolchainSpec.getConventionImplementation());
    }

    @Override
    public Property<JavaLanguageVersion> getLanguageVersion() {
        return this.languageVersion;
    }

    @Override
    public Property<JvmVendorSpec> getVendor() {
        return this.vendor;
    }

    @Override
    public Property<JvmImplementation> getImplementation() {
        return this.implementation;
    }

    @Override
    public JavaToolchainSpecInternal.Key toKey() {
        return new Key((JavaLanguageVersion)this.languageVersion.getOrNull(), (JvmVendorSpec)this.vendor.getOrNull(), (JvmImplementation)this.implementation.getOrNull());
    }

    @Override
    public boolean isConfigured() {
        return this.languageVersion.isPresent();
    }

    @Override
    public boolean isValid() {
        return this.languageVersion.isPresent() || this.isSecondaryPropertiesUnchanged();
    }

    private boolean isSecondaryPropertiesUnchanged() {
        return Objects.equals(DefaultToolchainSpec.getConventionVendor(), this.vendor.getOrNull()) && Objects.equals(DefaultToolchainSpec.getConventionImplementation(), this.implementation.getOrNull());
    }

    public String getDisplayName() {
        MoreObjects.ToStringHelper builder = MoreObjects.toStringHelper((String)"");
        builder.omitNullValues();
        builder.add("languageVersion", this.languageVersion.map(JavaLanguageVersion::toString).getOrElse((Object)"unspecified"));
        builder.add("vendor", this.vendor.map(Object::toString).getOrNull());
        builder.add("implementation", this.implementation.map(JvmImplementation::toString).getOrNull());
        return builder.toString();
    }

    @Override
    public void finalizeProperties() {
        this.getLanguageVersion().finalizeValue();
        this.getVendor().finalizeValue();
        this.getImplementation().finalizeValue();
    }

    public String toString() {
        return this.getDisplayName();
    }

    private static JvmVendorSpec getConventionVendor() {
        return DefaultJvmVendorSpec.any();
    }

    private static JvmImplementation getConventionImplementation() {
        return JvmImplementation.VENDOR_SPECIFIC;
    }

    public static class Key
    implements JavaToolchainSpecInternal.Key {
        private final JavaLanguageVersion languageVersion;
        private final JvmVendorSpec vendor;
        private final JvmImplementation implementation;

        public Key(@Nullable JavaLanguageVersion languageVersion, @Nullable JvmVendorSpec vendor, @Nullable JvmImplementation implementation) {
            this.languageVersion = languageVersion;
            this.vendor = vendor;
            this.implementation = implementation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key that = (Key)o;
            return Objects.equals(this.languageVersion, that.languageVersion) && Objects.equals(this.vendor, that.vendor) && Objects.equals(this.implementation, that.implementation);
        }

        public int hashCode() {
            return Objects.hash(this.languageVersion, this.vendor, this.implementation);
        }

        public String toString() {
            return "DefaultKey{languageVersion=" + this.languageVersion + ", vendor=" + this.vendor + ", implementation=" + this.implementation + '}';
        }
    }
}

